/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.outline;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.html.outline.HTMLOutlineContentProvider;
import com.aptana.editor.html.parsing.ast.HTMLTextNode;
import com.aptana.editor.php.internal.parser.nodes.IPHPParseNode;
import com.aptana.editor.php.internal.ui.editor.outline.PHPOutlineItem;
import com.aptana.parsing.ast.IParseNode;
import java.util.ArrayList;
import java.util.List;

public class PHTMLOutlineContentProvider
extends HTMLOutlineContentProvider {
    public PHTMLOutlineContentProvider(AbstractThemeableEditor editor) {
        super(editor);
    }

    public CommonOutlineItem getOutlineItem(IParseNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof IPHPParseNode) {
            return new PHPOutlineItem(node.getNameNode().getNameRange(), node);
        }
        return super.getOutlineItem(node);
    }

    protected Object[] filter(IParseNode[] nodes) {
        ArrayList<CommonOutlineItem> list = new ArrayList<CommonOutlineItem>();
        this.filterRecursively(nodes, list);
        return list.toArray(new CommonOutlineItem[list.size()]);
    }

    private void filterRecursively(IParseNode[] nodes, List<CommonOutlineItem> list) {
        IParseNode[] iParseNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode node = iParseNodeArray[n2];
            if (node instanceof IPHPParseNode) {
                IPHPParseNode element = (IPHPParseNode)node;
                if (!element.isFilteredFromOutline()) {
                    list.add(this.getOutlineItem(element));
                } else {
                    this.filterRecursively(node.getChildren(), list);
                }
            } else if (!(node instanceof HTMLTextNode)) {
                list.add(this.getOutlineItem(node));
            }
            ++n2;
        }
    }
}

